# Generated Python Strategy for: PlayerA (meta)
# Run Index: 1
# Primary LLM: DeepSeek-V3 (deepseek-ai/DeepSeek-V3-0324) Provider: novita
def PlayerA_DeepSeek_V3_MetaAgent_Run1_Iter0(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Heuristic 1: Check for simple strategies (always cooperate/defect)
    if "always_cooperate" in opponent_program_code.lower() or "return 'c'" in opponent_program_code.lower():
        return "C"
    if "always_defect" in opponent_program_code.lower() or "return 'd'" in opponent_program_code.lower():
        return "D"
    
    # Heuristic 2: Check for Tit-for-Tat-like strategies
    tit_for_tat_keywords = ["opp_history[-1]", "opp_history[len(my_history)-1]", "return opp_history[-1]"]
    if any(keyword in opponent_program_code for keyword in tit_for_tat_keywords):
        if not opp_history:
            return "C"
        return opp_history[-1]
    
    # Heuristic 3: Check for random strategies
    if "random.choice(['c', 'd'])" in opponent_program_code.lower() or "random.choice(['C', 'D'])" in opponent_program_code.lower():
        return "D"  # Defect against random strategies
    
    # Heuristic 4: Check for self-similarity (if opponent's code resembles our own)
    our_keywords = ["PlayerA_DeepSeek_V3_MetaAgent_Run1_Iter0", "heuristic", "opponent_program_code"]
    if sum(keyword in opponent_program_code for keyword in our_keywords) >= 2:
        return "C"  # Cooperate if opponent seems similar
    
    # Heuristic 5: Check for code length (short code might be simple, long might be complex)
    if len(opponent_program_code.splitlines()) < 5:
        return "C"  # Cooperate with simple strategies
    else:
        # For complex strategies, be cautious but start cooperatively
        if not my_history:
            return "C"
        if len(my_history) >= 3 and all(move == "D" for move in opp_history[-3:]):
            return "D"  # Defect if opponent defected last 3 times
    
    # Fallback: Tit-for-Tat with initial cooperation
    if not opp_history:
        return "C"
    return opp_history[-1]